/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.crafting;

import cpw.mods.fml.common.registry.GameRegistry;
import de.katzenpapst.amunra.AmunRa;
import de.katzenpapst.amunra.block.ARBlocks;
import de.katzenpapst.amunra.block.BlockStairsAR;
import de.katzenpapst.amunra.block.ore.BlockOreMulti;
import de.katzenpapst.amunra.block.ore.SubBlockOre;
import de.katzenpapst.amunra.crafting.CircuitFabricatorRecipe;
import de.katzenpapst.amunra.crafting.RocketRecipeHelper;
import de.katzenpapst.amunra.entity.spaceship.EntityShuttle;
import de.katzenpapst.amunra.item.ARItems;
import de.katzenpapst.amunra.item.ItemDamagePair;
import de.katzenpapst.amunra.schematic.SchematicPageShuttle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import micdoodle8.mods.galacticraft.api.prefab.core.BlockMetaPair;
import micdoodle8.mods.galacticraft.api.recipe.CircuitFabricatorRecipes;
import micdoodle8.mods.galacticraft.api.recipe.CompressorRecipes;
import micdoodle8.mods.galacticraft.api.recipe.INasaWorkbenchRecipe;
import micdoodle8.mods.galacticraft.api.recipe.ISchematicPage;
import micdoodle8.mods.galacticraft.api.recipe.SchematicRegistry;
import micdoodle8.mods.galacticraft.api.recipe.SpaceStationRecipe;
import micdoodle8.mods.galacticraft.core.blocks.BlockAirLockFrame;
import micdoodle8.mods.galacticraft.core.blocks.GCBlocks;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.items.GCItems;
import micdoodle8.mods.galacticraft.core.recipe.NasaWorkbenchRecipe;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.planets.asteroids.items.AsteroidsItems;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class RecipeHelper {
    public static SpaceStationRecipe mothershipRecipe;
    protected static Map<Item, Vector<INasaWorkbenchRecipe>> nasaWorkbenchRecipes;
    protected static List<CircuitFabricatorRecipe> circuitFabricatorRecipes;

    public static void initRecipes() {
        RecipeHelper.initNasaWorkbenchCrafting();
        if (AmunRa.isNHCoreLoaded) {
            return;
        }
        ItemStack freqModuleStack = new ItemStack(GCItems.basicItem, 1, 19);
        ItemStack enderWaferStack = ARItems.waferEnder.getItemStack(1);
        ItemStack lithiumMeshStack = ARItems.lithiumMesh.getItemStack(1);
        ItemStack uranMeshStack = ARItems.uraniumMesh.getItemStack(1);
        ItemStack lithiumGemStack = ARItems.lithiumGem.getItemStack(1);
        ItemStack compressedAluStack = new ItemStack(GCItems.basicItem, 1, 8);
        ItemStack compressedIronStack = new ItemStack(GCItems.basicItem, 1, 11);
        ItemStack compressedTinStack = new ItemStack(GCItems.basicItem, 1, 7);
        ItemStack compressedSteelStack = new ItemStack(GCItems.basicItem, 1, 9);
        ItemStack compressedTitaniumStack = new ItemStack(AsteroidsItems.basicItem, 1, 6);
        ItemStack button = new ItemStack(Item.func_150898_a((Block)Blocks.field_150430_aB), 1);
        ItemStack laserDiodeStack = ARItems.laserDiode.getItemStack(1);
        ItemStack cryoDiodeStack = ARItems.cryoDiode.getItemStack(1);
        ItemStack beamCore = new ItemStack(AsteroidsItems.basicItem, 1, 8);
        ItemStack waferSolar = new ItemStack(GCItems.basicItem, 1, 12);
        ItemStack waferAdvanced = new ItemStack(GCItems.basicItem, 1, 14);
        ItemStack thermalControllerStack = ARItems.thermalControl.getItemStack(1);
        ItemStack thermalStuff = new ItemStack(AsteroidsItems.basicItem, 1, 7);
        ItemStack heavyWire = new ItemStack(GCBlocks.aluminumWire, 1, 1);
        ItemStack tinCanStack = new ItemStack(GCItems.canister, 1, 0);
        GameRegistry.addShapelessRecipe((ItemStack)ARBlocks.getItemStack(ARBlocks.blockMethanePlanks, 4), (Object[])new Object[]{ARBlocks.getItemStack(ARBlocks.blockMethaneLog, 1)});
        GameRegistry.addShapelessRecipe((ItemStack)ARBlocks.getItemStack(ARBlocks.blockPodPlanks, 4), (Object[])new Object[]{ARBlocks.getItemStack(ARBlocks.blockPodBark, 1)});
        HashMap<Object, Integer> inputMap = new HashMap<Object, Integer>();
        inputMap.put(compressedTinStack, 64);
        inputMap.put(compressedAluStack, 16);
        inputMap.put(ARBlocks.getItemStack(ARBlocks.blockMothershipController, 1), 1);
        inputMap.put(Items.field_151042_j, 24);
        mothershipRecipe = new SpaceStationRecipe(inputMap);
        ArrayList<ItemStack> silicons = new ArrayList<ItemStack>();
        silicons.add(new ItemStack(GCItems.basicItem, 1, 2));
        silicons.addAll(OreDictionary.getOres((String)ConfigManagerCore.otherModsSilicon));
        ItemStack[] siliconArray = new ItemStack[silicons.size()];
        silicons.toArray(siliconArray);
        RecipeHelper.addCircuitFabricatorRecipe(enderWaferStack, new ItemStack(Items.field_151045_i), siliconArray, siliconArray, new ItemStack(Items.field_151137_ax), new ItemStack(Items.field_151079_bi));
        RecipeHelper.addCircuitFabricatorRecipe(lithiumMeshStack, lithiumGemStack, siliconArray, siliconArray, new ItemStack(Items.field_151137_ax), new ItemStack(Items.field_151121_aF));
        RecipeHelper.addCircuitFabricatorRecipe(uranMeshStack, "ingotUranium", siliconArray, siliconArray, new ItemStack(Items.field_151137_ax), lithiumMeshStack);
        CompressorRecipes.addRecipe((ItemStack)ARItems.lightPlating.getItemStack(1), (Object[])new Object[]{"XYX", "XYX", Character.valueOf('X'), new ItemStack(GCItems.basicItem, 1, 8), Character.valueOf('Y'), new ItemStack(AsteroidsItems.basicItem, 1, 6)});
        CompressorRecipes.addRecipe((ItemStack)ARItems.compressedGold.getItemStack(1), (Object[])new Object[]{"XX", Character.valueOf('X'), new ItemStack(Items.field_151043_k)});
        GameRegistry.addSmelting((ItemStack)ARBlocks.getItemStack(ARBlocks.blockBasaltCobble, 1), (ItemStack)ARBlocks.getItemStack(ARBlocks.blockBasalt, 1), (float)1.0f);
        GameRegistry.addSmelting((ItemStack)ARBlocks.getItemStack(ARBlocks.blockRedCobble, 1), (ItemStack)ARBlocks.getItemStack(ARBlocks.blockRedRock, 1), (float)1.0f);
        GameRegistry.addSmelting((ItemStack)ARBlocks.getItemStack(ARBlocks.blockYellowCobble, 1), (ItemStack)ARBlocks.getItemStack(ARBlocks.blockYellowRock, 1), (float)1.0f);
        GameRegistry.addSmelting((ItemStack)ARItems.ancientRebar.getItemStack(1), (ItemStack)ARItems.steelIngot.getItemStack(1), (float)1.5f);
        ItemStack battery = new ItemStack(GCItems.battery, 1, Short.MAX_VALUE);
        ItemStack liBattery = new ItemStack((Item)ARItems.batteryLithium, 1, Short.MAX_VALUE);
        ItemStack quBattery = new ItemStack((Item)ARItems.batteryQuantum, 1, Short.MAX_VALUE);
        ItemStack enBattery = new ItemStack((Item)ARItems.batteryEnder, 1, Short.MAX_VALUE);
        ItemStack nuBattery = new ItemStack((Item)ARItems.batteryNuclear, 1, Short.MAX_VALUE);
        ItemStack raygun = new ItemStack((Item)ARItems.raygun, 1, Short.MAX_VALUE);
        ItemStack cryogun = new ItemStack((Item)ARItems.cryogun, 1, Short.MAX_VALUE);
        ItemStack nanotool = new ItemStack((Item)ARItems.nanotool, 1, Short.MAX_VALUE);
        ItemStack[] batteries = new ItemStack[]{battery, liBattery, quBattery, enBattery, nuBattery};
        GameRegistry.addRecipe((ItemStack)liBattery, (Object[])new Object[]{" X ", "XBX", "XAX", Character.valueOf('X'), compressedAluStack, Character.valueOf('A'), enderWaferStack, Character.valueOf('B'), lithiumMeshStack});
        GameRegistry.addRecipe((ItemStack)enBattery, (Object[])new Object[]{" X ", "XBX", "XAX", Character.valueOf('X'), compressedAluStack, Character.valueOf('A'), enderWaferStack, Character.valueOf('B'), Blocks.field_150451_bX});
        GameRegistry.addRecipe((ItemStack)nuBattery, (Object[])new Object[]{" X ", "XBX", "XAX", Character.valueOf('X'), compressedAluStack, Character.valueOf('A'), enderWaferStack, Character.valueOf('B'), uranMeshStack});
        GameRegistry.addRecipe((ItemStack)laserDiodeStack, (Object[])new Object[]{"XXX", "ABC", "XXX", Character.valueOf('X'), compressedAluStack, Character.valueOf('A'), Blocks.field_150410_aZ, Character.valueOf('B'), ARItems.rubyGem.getItemStack(1), Character.valueOf('C'), beamCore});
        GameRegistry.addRecipe((ItemStack)cryoDiodeStack, (Object[])new Object[]{"XXX", "ABC", "XXX", Character.valueOf('X'), compressedAluStack, Character.valueOf('A'), Blocks.field_150410_aZ, Character.valueOf('B'), ARItems.coldCrystal.getItemStack(1), Character.valueOf('C'), beamCore});
        RecipeHelper.addRaygunRecipe(raygun, batteries, "XYZ", " AZ", "  B", Character.valueOf('X'), laserDiodeStack, Character.valueOf('Y'), enderWaferStack, Character.valueOf('Z'), compressedSteelStack, Character.valueOf('A'), button, Character.valueOf('B'), battery);
        RecipeHelper.addRaygunRecipe(cryogun, batteries, "XYZ", " AZ", "  B", Character.valueOf('X'), cryoDiodeStack, Character.valueOf('Y'), enderWaferStack, Character.valueOf('Z'), compressedSteelStack, Character.valueOf('A'), button, Character.valueOf('B'), battery);
        RecipeHelper.addRaygunRecipe(nanotool, batteries, "NCN", " H ", " B ", Character.valueOf('N'), ARItems.naniteCluster.getItemStack(1), Character.valueOf('C'), ARItems.naniteControl.getItemStack(1), Character.valueOf('H'), compressedTitaniumStack, Character.valueOf('B'), battery);
        GameRegistry.addRecipe((ItemStack)ARBlocks.getItemStack(ARBlocks.blockWorkbench, 1), (Object[])new Object[]{"XX ", "XX ", "   ", Character.valueOf('X'), compressedIronStack});
        GameRegistry.addRecipe((ItemStack)ARBlocks.getItemStack(ARBlocks.blockHydro, 2), (Object[])new Object[]{"GGG", "CDC", "TTT", Character.valueOf('G'), Blocks.field_150359_w, Character.valueOf('C'), GCBlocks.oxygenCollector, Character.valueOf('D'), Blocks.field_150346_d, Character.valueOf('T'), compressedTitaniumStack});
        GameRegistry.addRecipe((ItemStack)ARBlocks.getItemStack(ARBlocks.blockScale, 1), (Object[])new Object[]{"XXX", "ABC", "AAA", Character.valueOf('X'), compressedTinStack, Character.valueOf('A'), compressedSteelStack, Character.valueOf('B'), waferAdvanced, Character.valueOf('C'), Blocks.field_150410_aZ});
        GameRegistry.addRecipe((ItemStack)ARItems.shuttleTank.getItemStack(1), (Object[])new Object[]{"XXX", "XAX", "XXX", Character.valueOf('X'), compressedTinStack, Character.valueOf('A'), tinCanStack});
        GameRegistry.addRecipe((ItemStack)ARItems.dockGangway.getItemStack(1), (Object[])new Object[]{"IXI", "IXI", "IXI", Character.valueOf('X'), new ItemStack(Blocks.field_150325_L, 1, 15), Character.valueOf('I'), new ItemStack(GCItems.flagPole)});
        GameRegistry.addRecipe((ItemStack)ARItems.dockDoor.getItemStack(1), (Object[])new Object[]{"SSX", "SXS", "XSS", Character.valueOf('S'), compressedSteelStack, Character.valueOf('X'), compressedAluStack});
        GameRegistry.addRecipe((ItemStack)ARBlocks.getItemStack(ARBlocks.blockShuttleDock, 1), (Object[])new Object[]{"XCX", "DAG", "XCX", Character.valueOf('D'), ARItems.dockDoor.getItemStack(1), Character.valueOf('G'), ARItems.dockGangway.getItemStack(1), Character.valueOf('A'), Blocks.field_150409_cd, Character.valueOf('X'), new ItemStack(GCBlocks.airLockFrame, 1, BlockAirLockFrame.METADATA_AIR_LOCK_FRAME), Character.valueOf('C'), new ItemStack(GCBlocks.airLockFrame, 1, BlockAirLockFrame.METADATA_AIR_LOCK_CONTROLLER)});
        GameRegistry.addRecipe((ItemStack)ARBlocks.getItemStack(ARBlocks.blockGravity, 1), (Object[])new Object[]{"XBX", "XDA", "XWX", Character.valueOf('D'), ARItems.darkShard.getItemStack(1), Character.valueOf('W'), enderWaferStack, Character.valueOf('X'), compressedTitaniumStack, Character.valueOf('B'), beamCore, Character.valueOf('A'), ARItems.transformer.getItemStack(1)});
        GameRegistry.addShapelessRecipe((ItemStack)ARBlocks.getItemStack(ARBlocks.blockSmoothBasalt, 1), (Object[])new Object[]{ARBlocks.getItemStack(ARBlocks.blockBasalt, 1)});
        GameRegistry.addRecipe((ItemStack)ARBlocks.getItemStack(ARBlocks.blockBasaltBrick, 4), (Object[])new Object[]{"XX", "XX", Character.valueOf('X'), ARBlocks.getItemStack(ARBlocks.blockBasalt, 1)});
        GameRegistry.addRecipe((ItemStack)ARBlocks.getItemStack(ARBlocks.blockObsidianBrick, 4), (Object[])new Object[]{"XX", "XX", Character.valueOf('X'), Blocks.field_150343_Z});
        GameRegistry.addRecipe((ItemStack)ARBlocks.getItemStack(ARBlocks.blockAluCrate, 32), (Object[])new Object[]{" X ", "X X", " X ", Character.valueOf('X'), new ItemStack(GCItems.basicItem, 1, 8)});
        GameRegistry.addRecipe((ItemStack)ARBlocks.getItemStack(ARBlocks.blockUraniumBlock, 1), (Object[])new Object[]{"XXX", "XXX", "XXX", Character.valueOf('X'), ARItems.uraniumIngot.getItemStack(1)});
        GameRegistry.addShapelessRecipe((ItemStack)ARItems.uraniumIngot.getItemStack(9), (Object[])new Object[]{ARBlocks.getItemStack(ARBlocks.blockUraniumBlock, 1)});
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ARBlocks.getItemStack(ARBlocks.blockIsotopeGeneratorBasic, 1), new Object[]{"XAX", "XBC", "XDX", Character.valueOf('X'), compressedSteelStack, Character.valueOf('A'), waferAdvanced, Character.valueOf('B'), "ingotUranium", Character.valueOf('C'), new ItemStack(GCBlocks.aluminumWire, 1, 0), Character.valueOf('D'), waferSolar}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ARBlocks.getItemStack(ARBlocks.blockIsotopeGeneratorAdvanced, 1), new Object[]{"XAX", "XBC", "XDX", Character.valueOf('X'), compressedTitaniumStack, Character.valueOf('A'), enderWaferStack, Character.valueOf('B'), "blockUranium", Character.valueOf('C'), new ItemStack(GCBlocks.aluminumWire, 1, 1), Character.valueOf('D'), lithiumMeshStack}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ARBlocks.getItemStack(ARBlocks.chestAlu, 1), new Object[]{"XXX", "X X", "XXX", Character.valueOf('X'), "compressedAluminum"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ARBlocks.getItemStack(ARBlocks.chestSteel, 1), new Object[]{"XXX", "X X", "XXX", Character.valueOf('X'), "compressedSteel"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ARBlocks.getItemStack(ARBlocks.blockMothershipController, 1), new Object[]{"XBX", "XAG", "XCX", Character.valueOf('A'), freqModuleStack, Character.valueOf('B'), enderWaferStack, Character.valueOf('C'), AsteroidsItems.orionDrive, Character.valueOf('X'), "compressedTitanium", Character.valueOf('G'), Blocks.field_150410_aZ}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ARBlocks.getItemStack(ARBlocks.blockMothershipSettings, 1), new Object[]{"XBX", "XAG", "XXC", Character.valueOf('A'), freqModuleStack, Character.valueOf('B'), enderWaferStack, Character.valueOf('C'), Blocks.field_150442_at, Character.valueOf('X'), "compressedTitanium", Character.valueOf('G'), Blocks.field_150410_aZ}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ARItems.thermalControl.getItemStack(2), new Object[]{" A ", "XBX", " C ", Character.valueOf('A'), waferAdvanced, Character.valueOf('B'), new ItemStack(Items.field_151137_ax, 1), Character.valueOf('C'), GCItems.oxygenVent, Character.valueOf('X'), new ItemStack(GCItems.canister, 1, 0)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ARItems.thermalHelm.getItemStack(1), new Object[]{"XAX", "X X", "   ", Character.valueOf('A'), thermalControllerStack, Character.valueOf('X'), thermalStuff}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ARItems.thermalChest.getItemStack(1), new Object[]{"X X", "XAX", "XAX", Character.valueOf('A'), thermalControllerStack, Character.valueOf('X'), thermalStuff}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ARItems.thermalLegs.getItemStack(1), new Object[]{"XXX", "A A", "X X", Character.valueOf('A'), thermalControllerStack, Character.valueOf('X'), thermalStuff}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ARItems.thermalBoots.getItemStack(1), new Object[]{"   ", "A A", "X X", Character.valueOf('A'), thermalControllerStack, Character.valueOf('X'), thermalStuff}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ARItems.tricorder.getItemStack(1), new Object[]{"XAX", "XBC", "XDE", Character.valueOf('X'), compressedTinStack, Character.valueOf('A'), freqModuleStack, Character.valueOf('B'), waferAdvanced, Character.valueOf('C'), Blocks.field_150410_aZ, Character.valueOf('D'), nuBattery, Character.valueOf('E'), Blocks.field_150430_aB}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ARItems.naniteControl.getItemStack(1), new Object[]{"XAX", "CBC", "XDX", Character.valueOf('X'), compressedTinStack, Character.valueOf('C'), freqModuleStack, Character.valueOf('B'), beamCore, Character.valueOf('D'), lithiumMeshStack, Character.valueOf('A'), ARItems.naniteCluster.getItemStack(1)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ARItems.gravityDisabler.getItemStack(1), new Object[]{"XEX", "RMR", "XBX", Character.valueOf('X'), compressedAluStack, Character.valueOf('E'), enderWaferStack, Character.valueOf('R'), Items.field_151137_ax, Character.valueOf('M'), ARItems.darkShard.getItemStack(1), Character.valueOf('B'), nuBattery}));
        ItemStack rocketBoosterTier1 = new ItemStack(GCItems.rocketEngine, 1, 1);
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ARBlocks.getItemStack(ARBlocks.blockMsEngineRocketJet, 1), new Object[]{"X X", " AB", "X X", Character.valueOf('A'), new ItemStack(AsteroidsItems.basicItem, 1, 1), Character.valueOf('B'), rocketBoosterTier1, Character.valueOf('X'), "compressedTitanium"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ARBlocks.getItemStack(ARBlocks.blockMsEngineRocketBooster, 1), new Object[]{"XXX", "BCB", "XXX", Character.valueOf('B'), rocketBoosterTier1, Character.valueOf('C'), new ItemStack(GCItems.canister, 1, 0), Character.valueOf('X'), "compressedTitanium"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ARBlocks.getItemStack(ARBlocks.blockMsEngineIonJet, 1), new Object[]{"XXX", "BA ", "XXX", Character.valueOf('A'), ARItems.goldFoil.getItemStack(1), Character.valueOf('B'), beamCore, Character.valueOf('X'), "compressedTitanium"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ARBlocks.getItemStack(ARBlocks.blockMsEngineIonBooster, 1), new Object[]{"XCX", "BAB", "XXX", Character.valueOf('A'), ARItems.goldFoil.getItemStack(1), Character.valueOf('B'), beamCore, Character.valueOf('C'), ARItems.transformer.getItemStack(1), Character.valueOf('X'), "compressedTitanium"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ARItems.shuttleLegs.getItemStack(1), new Object[]{"AXA", "X  ", "A  ", Character.valueOf('X'), new ItemStack(GCItems.flagPole), Character.valueOf('A'), "compressedTitanium"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ARItems.noseCone.getItemStack(1), new Object[]{" X ", "XAX", "   ", Character.valueOf('A'), ARItems.lightPlating.getItemStack(1), Character.valueOf('X'), "compressedTitanium"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ARItems.goldFoil.getItemStack(1), new Object[]{"XAX", "AXA", "XAX", Character.valueOf('A'), compressedAluStack, Character.valueOf('X'), "compressedGold"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ARItems.transformer.getItemStack(1), new Object[]{"XAX", "XAX", "XAX", Character.valueOf('A'), heavyWire, Character.valueOf('X'), "compressedMeteoricIron"}));
        RecipeHelper.initOreSmelting();
        RecipeHelper.addSlabAndStairsCrafting(ARBlocks.blockAluCrate, ARBlocks.slabAluCrate, ARBlocks.stairsAluCrate);
        RecipeHelper.addSlabAndStairsCrafting(ARBlocks.blockBasalt, ARBlocks.slabBasaltBlock, ARBlocks.stairsBasaltBlock);
        RecipeHelper.addSlabAndStairsCrafting(ARBlocks.blockBasaltBrick, ARBlocks.slabBasaltBrick, ARBlocks.stairsBasaltBrick);
        RecipeHelper.addSlabAndStairsCrafting(ARBlocks.blockSmoothBasalt, ARBlocks.slabBasaltSmooth, ARBlocks.stairsSmoothBasalt);
        RecipeHelper.addSlabAndStairsCrafting(ARBlocks.blockMethanePlanks, ARBlocks.slabMethanePlanks, ARBlocks.stairsMethanePlanks);
        RecipeHelper.addSlabAndStairsCrafting(ARBlocks.blockObsidianBrick, ARBlocks.slabObsidianBrick, ARBlocks.stairsObsidianBrick);
        RecipeHelper.addSlabAndStairsCrafting(ARBlocks.blockPodPlanks, ARBlocks.slabPodPlanks, ARBlocks.stairsPodPlanks);
    }

    public static void verifyNasaWorkbenchCrafting() {
        HashMap<Integer, ISchematicPage> pagesByPageID = new HashMap<Integer, ISchematicPage>();
        HashMap<Integer, ISchematicPage> pagesByGuiID = new HashMap<Integer, ISchematicPage>();
        for (ISchematicPage page : SchematicRegistry.schematicRecipes) {
            ISchematicPage oldPage;
            int curPageID = page.getPageID();
            int curGuiID = page.getGuiID();
            if (pagesByPageID.containsKey(curPageID)) {
                oldPage = (ISchematicPage)pagesByPageID.get(curPageID);
                if (AmunRa.config.schematicIdShuttle == curPageID) {
                    throw new RuntimeException("Please change shuttleSchematicsId in the config file. " + curPageID + " is already in use.");
                }
                AmunRa.LOGGER.warn("Possible Page ID conflict: {} and {} on {}", new Object[]{page.getClass().getName(), oldPage.getClass().getName(), curPageID});
            } else {
                pagesByPageID.put(curPageID, page);
            }
            if (pagesByGuiID.containsKey(curGuiID)) {
                oldPage = (ISchematicPage)pagesByGuiID.get(curGuiID);
                if (AmunRa.config.guiIdShuttle == curGuiID) {
                    throw new RuntimeException("Please change shuttleGuiId in the config file. " + curGuiID + " is already in use.");
                }
                AmunRa.LOGGER.warn("Possible Page ID conflict: {} and {} on {}", new Object[]{page.getClass().getName(), oldPage.getClass().getName(), curPageID});
                continue;
            }
            pagesByGuiID.put(curGuiID, page);
        }
    }

    protected static void addCircuitFabricatorRecipe(ItemStack output, Object ... inputs) {
        ItemStack[] optional = null;
        if (inputs.length < 4) {
            throw new RuntimeException("Not enough inputs for circuit fabricator");
        }
        ItemStack[] crystal = RecipeHelper.getStacksForInput(inputs[0]);
        ItemStack[] silicon1 = RecipeHelper.getStacksForInput(inputs[1]);
        ItemStack[] silicon2 = RecipeHelper.getStacksForInput(inputs[2]);
        ItemStack[] redstone = RecipeHelper.getStacksForInput(inputs[3]);
        if (inputs.length > 4) {
            optional = RecipeHelper.getStacksForInput(inputs[4]);
        }
        RecipeHelper.addCircuitFabricatorRecipe(output, crystal, silicon1, silicon2, redstone, optional);
    }

    private static ItemStack[] getStacksForInput(Object input) {
        if (input instanceof ItemStack) {
            ItemStack inputAsStack = (ItemStack)input;
            return new ItemStack[]{inputAsStack};
        }
        if (input instanceof String) {
            String inputAsString = (String)input;
            ArrayList ores = OreDictionary.getOres((String)inputAsString);
            ItemStack[] asArray = new ItemStack[ores.size()];
            ores.toArray(asArray);
            return asArray;
        }
        if (input instanceof ItemStack[]) {
            ItemStack[] inputAsStacks = (ItemStack[])input;
            return inputAsStacks;
        }
        throw new RuntimeException("Bad input");
    }

    protected static void addCircuitFabricatorRecipe(ItemStack output, ItemStack[] crystal, ItemStack[] silicon1, ItemStack[] silicon2, ItemStack[] redstone, ItemStack[] optional) {
        CircuitFabricatorRecipe cfr = new CircuitFabricatorRecipe(output, crystal, silicon1, silicon2, redstone, optional);
        circuitFabricatorRecipes.add(cfr);
        for (ItemStack element : crystal) {
            for (ItemStack element2 : silicon1) {
                for (ItemStack element3 : silicon2) {
                    for (ItemStack element4 : redstone) {
                        if (optional.length > 0) {
                            for (ItemStack element5 : optional) {
                                RecipeHelper.addCircuitFabricatorRecipeInternal(output, element, element2, element3, element4, element5);
                            }
                            continue;
                        }
                        RecipeHelper.addCircuitFabricatorRecipeInternal(output, element, element2, element3, element4, null);
                    }
                }
            }
        }
    }

    protected static void addCircuitFabricatorRecipeInternal(ItemStack output, ItemStack crystal, ItemStack silicon1, ItemStack silicon2, ItemStack redstone, ItemStack optional) {
        if (optional != null) {
            CircuitFabricatorRecipes.addRecipe((ItemStack)output, (ItemStack[])new ItemStack[]{crystal, silicon1, silicon2, redstone, optional});
        } else {
            CircuitFabricatorRecipes.addRecipe((ItemStack)output, (ItemStack[])new ItemStack[]{crystal, silicon1, silicon2, redstone});
        }
    }

    private static void initNasaWorkbenchCrafting() {
        SchematicRegistry.registerSchematicRecipe((ISchematicPage)new SchematicPageShuttle());
        ItemStack lightPlate = ARItems.lightPlating.getItemStack(1);
        ItemStack shuttleLeg = ARItems.shuttleLegs.getItemStack(1);
        HashMap<Integer, ItemStack> input = new HashMap<Integer, ItemStack>();
        if (AmunRa.isNHCoreLoaded && AmunRa.isASPLoaded) {
            ItemStack fins = GameRegistry.findItemStack((String)"dreamcraft", (String)"item.HeavyDutyRocketFinsTier4", (int)1);
            input.put(1, ARItems.noseCone.getItemStack(1));
            input.put(2, lightPlate);
            input.put(3, lightPlate);
            input.put(4, lightPlate);
            input.put(5, lightPlate);
            input.put(6, new ItemStack(GameRegistry.findItem((String)"AdvancedSolarPanel", (String)"asp_crafting_items"), 1, 5));
            input.put(7, lightPlate);
            input.put(8, lightPlate);
            input.put(9, lightPlate);
            input.put(10, lightPlate);
            input.put(11, fins);
            input.put(12, lightPlate);
            input.put(13, lightPlate);
            input.put(14, lightPlate);
            input.put(15, fins);
            input.put(16, shuttleLeg);
            input.put(17, GameRegistry.findItemStack((String)"dreamcraft", (String)"item.HeavyDutyRocketEngineTier4", (int)1));
            input.put(18, shuttleLeg);
        } else {
            input.put(1, ARItems.noseCone.getItemStack(1));
            input.put(2, lightPlate);
            input.put(3, lightPlate);
            input.put(4, lightPlate);
            input.put(5, lightPlate);
            input.put(6, new ItemStack(Blocks.field_150410_aZ, 1, 0));
            input.put(7, lightPlate);
            input.put(8, lightPlate);
            input.put(9, lightPlate);
            input.put(10, lightPlate);
            input.put(11, new ItemStack(GCItems.partFins));
            input.put(12, lightPlate);
            input.put(13, lightPlate);
            input.put(14, lightPlate);
            input.put(15, new ItemStack(GCItems.partFins));
            input.put(16, shuttleLeg);
            input.put(17, new ItemStack(GCItems.rocketEngine));
            input.put(18, shuttleLeg);
        }
        input.put(19, null);
        input.put(20, null);
        input.put(21, null);
        RecipeHelper.addRocketRecipeWithChestPermutations(ARItems.shuttleItem, input);
    }

    private static void initOreSmelting() {
        RecipeHelper.addSmeltingForMultiOre(ARBlocks.metaBlockBasaltOre);
        RecipeHelper.addSmeltingForMultiOre(ARBlocks.metaBlockObsidianOre);
        RecipeHelper.addSmeltingForMultiOre(ARBlocks.metaBlockHardClayOre);
        RecipeHelper.addSmeltingForMultiOre(ARBlocks.metaBlockConcreteOre);
        RecipeHelper.addSmeltingForMultiOre(ARBlocks.metaBlockAsteroidOre);
    }

    private static void addSmeltingForMultiOre(BlockOreMulti block) {
        for (int i = 0; i < block.getNumPossibleSubBlocks(); ++i) {
            SubBlockOre sb = (SubBlockOre)block.getSubBlock(i);
            if (sb == null || sb.getSmeltItem() == null) continue;
            ItemStack input = new ItemStack((Block)block, 1, i);
            GameRegistry.addSmelting((ItemStack)input, (ItemStack)sb.getSmeltItem(), (float)1.0f);
        }
    }

    private static void addSlabAndStairsCrafting(BlockMetaPair block, BlockMetaPair slab, BlockStairsAR stairsAluCrate) {
        ItemStack blockStack = ARBlocks.getItemStack(block, 1);
        GameRegistry.addRecipe((ItemStack)ARBlocks.getItemStack(slab, 6), (Object[])new Object[]{"XXX", Character.valueOf('X'), blockStack});
        GameRegistry.addRecipe((ItemStack)blockStack, (Object[])new Object[]{"X", "X", Character.valueOf('X'), ARBlocks.getItemStack(slab, 1)});
        ItemStack stairStack = new ItemStack((Block)stairsAluCrate, 4);
        GameRegistry.addRecipe((ItemStack)stairStack, (Object[])new Object[]{"  X", " XX", "XXX", Character.valueOf('X'), blockStack});
        GameRegistry.addRecipe((ItemStack)stairStack, (Object[])new Object[]{"X  ", "XX ", "XXX", Character.valueOf('X'), blockStack});
    }

    private static void addRaygunRecipe(ItemStack gun, ItemStack[] batteries, Object ... recipe) {
        for (ItemStack battery : batteries) {
            ItemStack lastStack;
            Object[] modifiedRecipe = (Object[])recipe.clone();
            Object lastObject = modifiedRecipe[modifiedRecipe.length - 1];
            if (!(lastObject instanceof ItemStack) || !((lastStack = (ItemStack)lastObject).func_77973_b() instanceof ItemElectricBase)) {
                throw new RuntimeException("Bad Raygun Recipe!");
            }
            modifiedRecipe[modifiedRecipe.length - 1] = battery;
            GameRegistry.addRecipe((ItemStack)gun, (Object[])modifiedRecipe);
            GameRegistry.addShapelessRecipe((ItemStack)gun, (Object[])new Object[]{gun, battery});
        }
    }

    public static void addRocketRecipeWithChestPermutations(Item rocket, HashMap<Integer, ItemStack> input) {
        ItemStack chest;
        int chestSlot1 = 19;
        int chestSlot2 = 20;
        int chestSlot3 = 21;
        if (AmunRa.isIronChestsLoaded) {
            chest = GameRegistry.findItemStack((String)"IronChest", (String)"BlockIronChest", (int)1);
            Items.field_151034_e.setDamage(chest, 3);
        } else {
            chest = new ItemStack((Block)Blocks.field_150486_ae);
        }
        ItemStack tank = AmunRa.isIronTanksLoaded ? GameRegistry.findItemStack((String)"irontank", (String)"copperTank", (int)1) : ARItems.shuttleTank.getItemStack(1);
        RocketRecipeHelper rrh = new RocketRecipeHelper(null);
        RecipeHelper.addRocketRecipeWithChestPermutations(new ItemStack(rocket, 1, EntityShuttle.encodeItemDamage(0, 0)), input, 19, 20, 21, rrh);
        rrh = new RocketRecipeHelper(chest, null);
        RecipeHelper.addRocketRecipeWithChestPermutations(new ItemStack(rocket, 1, EntityShuttle.encodeItemDamage(1, 0)), input, 19, 20, 21, rrh);
        rrh = new RocketRecipeHelper(null, chest);
        RecipeHelper.addRocketRecipeWithChestPermutations(new ItemStack(rocket, 1, EntityShuttle.encodeItemDamage(2, 0)), input, 19, 20, 21, rrh);
        rrh = new RocketRecipeHelper(chest);
        RecipeHelper.addRocketRecipeWithChestPermutations(new ItemStack(rocket, 1, EntityShuttle.encodeItemDamage(3, 0)), input, 19, 20, 21, rrh);
        rrh = new RocketRecipeHelper(tank, null);
        RecipeHelper.addRocketRecipeWithChestPermutations(new ItemStack(rocket, 1, EntityShuttle.encodeItemDamage(0, 1)), input, 19, 20, 21, rrh);
        rrh = new RocketRecipeHelper(null, tank);
        RecipeHelper.addRocketRecipeWithChestPermutations(new ItemStack(rocket, 1, EntityShuttle.encodeItemDamage(0, 2)), input, 19, 20, 21, rrh);
        rrh = new RocketRecipeHelper(tank);
        RecipeHelper.addRocketRecipeWithChestPermutations(new ItemStack(rocket, 1, EntityShuttle.encodeItemDamage(0, 3)), input, 19, 20, 21, rrh);
        rrh = new RocketRecipeHelper(tank, chest, null);
        RecipeHelper.addRocketRecipeWithChestPermutations(new ItemStack(rocket, 1, EntityShuttle.encodeItemDamage(1, 1)), input, 19, 20, 21, rrh);
        rrh = new RocketRecipeHelper(tank, chest);
        RecipeHelper.addRocketRecipeWithChestPermutations(new ItemStack(rocket, 1, EntityShuttle.encodeItemDamage(2, 1)), input, 19, 20, 21, rrh);
        rrh = new RocketRecipeHelper(chest, tank);
        RecipeHelper.addRocketRecipeWithChestPermutations(new ItemStack(rocket, 1, EntityShuttle.encodeItemDamage(1, 2)), input, 19, 20, 21, rrh);
    }

    public static void addRocketRecipeWithChestPermutations(ItemStack output, HashMap<Integer, ItemStack> incompleteInput, int chestSlot1, int chestSlot2, int chestSlot3, RocketRecipeHelper rrh) {
        List<ItemStack> chest1 = rrh.getStacks(0);
        List<ItemStack> chest2 = rrh.getStacks(1);
        List<ItemStack> chest3 = rrh.getStacks(2);
        for (int i = 0; i < chest1.size(); ++i) {
            HashMap<Integer, ItemStack> input = new HashMap<Integer, ItemStack>(incompleteInput);
            input.put(chestSlot1, chest1.get(i));
            input.put(chestSlot2, chest2.get(i));
            input.put(chestSlot3, chest3.get(i));
            RecipeHelper.addNasaWorkbenchRecipe(output, input);
        }
    }

    public static void addNasaWorkbenchRecipe(ItemStack result, HashMap<Integer, ItemStack> input) {
        RecipeHelper.addNasaWorkbenchRecipe((INasaWorkbenchRecipe)new NasaWorkbenchRecipe(result, input));
    }

    public static void addNasaWorkbenchRecipe(INasaWorkbenchRecipe recipe) {
        Item item = recipe.getRecipeOutput().func_77973_b();
        Vector<Object> recipeArray = nasaWorkbenchRecipes.get(item);
        if (recipeArray == null) {
            recipeArray = new Vector();
            nasaWorkbenchRecipes.put(item, recipeArray);
        }
        recipeArray.addElement(recipe);
    }

    public static ItemStack findMatchingRecipeFor(Item expectedOutput, IInventory craftMatrix) {
        Vector<INasaWorkbenchRecipe> recipeArray = nasaWorkbenchRecipes.get(expectedOutput);
        if (recipeArray == null) {
            return null;
        }
        for (INasaWorkbenchRecipe recipe : recipeArray) {
            if (!recipe.matches(craftMatrix)) continue;
            return recipe.getRecipeOutput();
        }
        return null;
    }

    public static Vector<INasaWorkbenchRecipe> getAllRecipesFor(Item expectedOutput) {
        return nasaWorkbenchRecipes.get(expectedOutput);
    }

    public static INasaWorkbenchRecipe getMostCompleteRecipeFor(Item expectedOutput) {
        if (nasaWorkbenchRecipes.containsKey(expectedOutput)) {
            return nasaWorkbenchRecipes.get(expectedOutput).lastElement();
        }
        return null;
    }

    public static Map<Integer, Set<ItemDamagePair>> getNasaWorkbenchRecipeForContainer(Item expectedOutput) {
        HashMap<Integer, Set<ItemDamagePair>> result = new HashMap<Integer, Set<ItemDamagePair>>();
        Vector<INasaWorkbenchRecipe> recipeArray = nasaWorkbenchRecipes.get(expectedOutput);
        for (INasaWorkbenchRecipe curRecipe : recipeArray) {
            Iterator iterator = curRecipe.getRecipeInput().keySet().iterator();
            while (iterator.hasNext()) {
                int slotNr = (Integer)iterator.next();
                result.computeIfAbsent(slotNr, t -> new HashSet());
                ItemStack stack = (ItemStack)curRecipe.getRecipeInput().get(slotNr);
                if (stack == null) continue;
                ItemDamagePair type = new ItemDamagePair(stack);
                if (((Set)result.get(slotNr)).contains(type)) continue;
                ((Set)result.get(slotNr)).add(type);
            }
        }
        return result;
    }

    public static List<CircuitFabricatorRecipe> getCircuitFabricatorRecipes() {
        return circuitFabricatorRecipes;
    }

    static {
        nasaWorkbenchRecipes = new HashMap<Item, Vector<INasaWorkbenchRecipe>>();
        circuitFabricatorRecipes = new ArrayList<CircuitFabricatorRecipe>();
    }
}

